% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geneDrugPerturbation.R
\name{geneDrugPerturbation}
\alias{geneDrugPerturbation}
\title{Compute gene-drug associations}
\usage{
geneDrugPerturbation(x, concentration, type, batch, duration, model = FALSE)
}
\arguments{
\item{x}{\link{numeric} Vector of gene expression values}

\item{concentration}{\link{numeric} Vector with drug concentrations/doses}

\item{type}{\link{factor} Vector of factors specifying the cell lines or type types}

\item{batch}{\link{factor} Vector of factors specifying the batch}

\item{duration}{\link{character} Vector of measurement times (in hours)}

\item{model}{\link{logical} Should the full linear model be returned? Default set to FALSE}
}
\value{
\link{numeric} Vector reporting the effect size (estimateof the coefficient of drug concentration), standard error (se), sample size (n), t statistic, and F statistics and its corresponding p-value
}
\description{
Function computing gene-drug associations from perturbation data
}
\examples{
ToxicoGx::drugPerturbationSig(tSet = TGGATESsmall,
  mDataType="rna",
  cell_lines="Hepatocyte",
  duration="24",
  dose=c("Control", "Low"),
  drugs=c("Omeprazole", "Isoniazid"),
  returnValues=c("estimate","tstat", "pvalue", "fdr"),
  verbose=FALSE)

}
\keyword{internal}
