% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tsa_analysis.R
\name{Tm_est}
\alias{Tm_est}
\title{Find inflection point function}
\usage{
Tm_est(norm_data, min, max)
}
\arguments{
\item{norm_data}{data frame; data frame input containing derivative values
can only be data frames for one well; finding inflections points across
multiple wells require iteration through individual wells}

\item{min}{restricts finding to be above the given minimum temperature}

\item{max}{restricts finding to be below the given maximum temperature
parameter min and max can be used to remove messy or undesired data
for better accuracy in tm estimation; removing data is  before fitting
the model is more recommended than removing here}
}
\value{
integer; tm estimation
}
\description{
Looks for Tm temperature values by finding the inflection point in the
    fluorescence data. The inflection point is approximated by
    locating the maximum first derivative stored in "norm_deriv" column.
}
\examples{
data("qPCR_data1")
test <- subset(qPCR_data1, Well.Position == "A01")
test <- normalize(test, fluo = 5, selected = c(
    "Well.Position", "Temperature",
    "Fluorescence", "Normalized"
))
gammodel <- model_gam(test, x = test$Temperature, y = test$Normalized)
fit <- model_fit(test, model = gammodel)
Tm_est(fit)

}
\seealso{
Other tsa_analysis: 
\code{\link{gam_analysis}()}
}
\concept{tsa_analysis}
