% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rank_invariance_express.R
\name{rank_invariance_express}
\alias{rank_invariance_express}
\title{Calculate the Rank Invariance of Each Gene from SCE object}
\usage{
rank_invariance_express(sce, group_col = "cellType", assay = "logcounts")
}
\arguments{
\item{sce}{\link[SummarizedExperiment:SummarizedExperiment-class]{SummarizedExperiment-class} object with
the \code{assay} (defaults to \code{logcounts}).}

\item{group_col}{name of the column in the
\link[SummarizedExperiment:SummarizedExperiment-class]{colData()} of \code{sce}
that defines the group of interest.}

\item{assay}{A \code{character(1)} specifying the name of the
\link[SummarizedExperiment:SummarizedExperiment-class]{assay()} in the
\code{sce} object to use to rank expression values. Defaults to \code{logcounts} since
it typically contains the normalized expression values.}
}
\value{
A \code{numeric()} with the rank of invariance for each gene. High values
represent low Rank Invariance, these genes are considered good candidate TREGs.
}
\description{
This function computes the Rank Invariance value for each gene, over the
groups defined by the user. This function computes the same RI values as running
\code{rank_cells()} + \code{rank_group()} + \code{rank_invariance()}.
Genes with high RI values are considered good candidate TREGs. This function is
more efficient than running the previous three functions.
}
\examples{
## Calculate RI for the sce object
## Highest RI value is best candidate TREG, and can change based on the grouping of interest
rank_invariance_express(sce_zero_test, group_col = "group")
rank_invariance_express(sce_zero_test, group_col = "cellType")
}
\seealso{
Other invariance functions: 
\code{\link{rank_cells}()},
\code{\link{rank_group}()},
\code{\link{rank_invariance}()}
}
\concept{invariance functions}
