% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rank_group.R
\name{rank_group}
\alias{rank_group}
\title{Get the Rank of the Mean expression for each Gene in each Group}
\usage{
rank_group(sce, group_col = "cellType", assay = "logcounts")
}
\arguments{
\item{sce}{\link[SummarizedExperiment:SummarizedExperiment-class]{SummarizedExperiment-class} object with
the \code{assay} (defaults to \code{logcounts}).}

\item{group_col}{name of the column in the
\link[SummarizedExperiment:SummarizedExperiment-class]{colData()} of \code{sce}
that defines the group of interest.}

\item{assay}{A \code{character(1)} specifying the name of the
\link[SummarizedExperiment:SummarizedExperiment-class]{assay()} in the
\code{sce} object to use to rank expression values. Defaults to \code{logcounts} since
it typically contains the normalized expression values.}
}
\value{
Named \code{list()} of ranks for each gene.
}
\description{
This function finds the rank of each gene's mean expression all cells in a
group. This data is used to compute the rank invariance value for each gene
later with \code{rank_invariance()}.
}
\examples{
## Rank the genes for each group defined by "group" column
rank_group(sce_zero_test, group_col = "group")
}
\seealso{
Other invariance functions: 
\code{\link{rank_cells}()},
\code{\link{rank_invariance_express}()},
\code{\link{rank_invariance}()}
}
\concept{invariance functions}
