% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tpptrNormalize.R
\name{tpptrNormalize}
\alias{tpptrNormalize}
\title{Normalize protein fold changes}
\usage{
tpptrNormalize(
  data,
  normReqs = tpptrDefaultNormReqs(),
  qcPlotTheme = tppDefaultTheme(),
  qcPlotPath = NULL,
  startPars = c(Pl = 0, a = 550, b = 10),
  maxAttempts = 1,
  fixedReference = NULL
)
}
\arguments{
\item{data}{List of \code{ExpressionSet}s with protein fold changes to be 
normalized.}

\item{normReqs}{List of filtering criteria for construction of the 
normalization set.}

\item{qcPlotTheme}{ggplot theme for the created plots}

\item{qcPlotPath}{location where plots of the curves fitted to the 
normalization set medians should be stored.}

\item{startPars}{start values for the melting curve parameters. Will be 
passed to function \code{\link{nls}} for curve fitting.}

\item{maxAttempts}{maximal number of curve attempts to fit melting curve to 
fold change medians when computing normalization factors.}

\item{fixedReference}{name of a fixed reference experiment for normalization. 
If NULL (default), the experiment with the best R2 when fitting a melting 
curve through the median fold changes is chosen as the reference.}
}
\value{
A list of ExpressionSets storing the normalized data for each
  experiment. Each ExpressionSet contains the measured fold changes, as well
  as row and column metadata. In each ExpressionSet \code{S}, the fold
  changes can be accessed by \code{Biobase::exprs(S)}. Protein expNames can be
  accessed by \code{featureNames(S)}. Isobaric labels and the corresponding temperatures are 
  returned by \code{S$label} and \code{S$temperature}
}
\description{
Normalizes fold changes determined by TPP-TR experiments over 
  different experimental groups.
}
\details{
Performs normalization of all fold changes in a given list of 
  ExpressionSets. The normalization procedure is described in detail in 
  Savitski et al. (2014). Whether normalization needs to be performed and 
  what method is best suited depends on the experiment. Here we provide a 
  reasonable solution for the data at hand.
  
  We distinguish between filtering conditions on fold changes and on 
  additional annotation columns. Correspondingly, \code{normReqs} contains 
  two fields, \code{fcFilters} and \code{otherFilters}. Each entry contains a
  data frame with three columns specifying the column to be filtered, as well
  as upper and lower bounds. An example is given by 
  \code{\link{tpptrDefaultNormReqs}}.
}
\examples{
data(hdacTR_smallExample)
tpptrData <- tpptrImport(hdacTR_config, hdacTR_data)
tpptrNorm <- tpptrNormalize(data=tpptrData, normReqs=tpptrDefaultNormReqs())
names(tpptrNorm)

}
\references{
Savitski, M. M., Reinhard, F. B., Franken, H., Werner, T., 
  Savitski, M. F., Eberhard, D., ... & Drewes, G. (2014). Tracking cancer 
  drugs in living cells by thermal profiling of the proteome. Science, 
  346(6205), 1255784.
  
  Franken, H, Mathieson, T, Childs, D. Sweetman, G. Werner, T. Huber, W. & Savitski, M. M. (2015),
  Thermal proteome profiling for unbiased identification of drug targets and detection of downstream effectors.
  Nature protocols 10(10), 1567-1593.
}
\seealso{
\code{\link{tpptrImport}}
}
