% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tpptrFitSplines.R
\name{tpptrFitSplines}
\alias{tpptrFitSplines}
\title{Perform spline fitting}
\usage{
tpptrFitSplines(
  data,
  factorsH1,
  factorsH0 = character(0),
  splineDF = 3:7,
  computeAUC = NULL,
  returnModels = TRUE,
  nCores = "max"
)
}
\arguments{
\item{data}{the data to be fitted}

\item{factorsH1}{which factors should be included in the alternative model?}

\item{factorsH0}{which factors should be included in the null model?}

\item{splineDF}{degrees of freedom for natural spline fitting.}

\item{computeAUC}{DEPRECATED}

\item{returnModels}{should the linear models be returned in a column of the
result table? Activation increases memory requirements.}

\item{nCores}{either a numerical value given the desired number of CPUs, or 
  'max' to automatically assign the maximum possible number (default).

Argument \code{splineDF} specifies the degrees of freedom for natural spline 
fitting. As a single numeric value, it is directly passed on to the \code{splineDF} argument of 
\code{splines::ns}. Experience shows that \code{splineDF = 4} yields good results for TPP
data sets with 10 temperature points. It is also possible to provide a numeric vector. 
In this case, splines are fitted for each entry and the optimal value is chosen
per protein using Akaike's Information criterion.}
}
\value{
A table containing the fitted models per protein
}
\description{
Fit natural splines to all proteins in a dataset.
}
\examples{
data(hdacTR_smallExample)
tpptrData <- tpptrImport(configTable = hdacTR_config, data = hdacTR_data)
normResults <- tpptrNormalize(data = tpptrData, 
               normReqs = tpptrDefaultNormReqs())
normData_eSets <- normResults$normData
normData_longTable <- tpptrTidyUpESets(normData_eSets)
hdacSubset <- subset(normData_longTable, grepl("HDAC", uniqueID))
hdacSplineFits <- tpptrFitSplines(data = hdacSubset, 
                                  factorsH1 = c("condition"), 
                                  nCores = 1)

}
\seealso{
\code{\link{ns}, \link{AICc}}
}
