% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import_funcs.R
\name{import2dMain}
\alias{import2dMain}
\title{Import 2D-TPP dataset main function}
\usage{
import2dMain(
  configTable,
  data,
  idVar,
  fcStr,
  addCol,
  naStrs,
  intensityStr,
  qualColName,
  nonZeroCols
)
}
\arguments{
\item{configTable}{character string of a file path to a config table}

\item{data}{possible list of datasets from different MS runs 
corresponding to a 2D-TPP dataset, circumvents loading datasets 
referencend in config table, default is NULL}

\item{idVar}{character string indicating which data column provides the 
unique identifiers for each protein.}

\item{fcStr}{character string indicating which columns contain the actual 
fold change values. Those column names containing the suffix \code{fcStr} 
will be regarded as containing fold change values.}

\item{addCol}{character string indicating additional column to import}

\item{naStrs}{character vector indicating missing values in the data table. 
When reading data from file, this value will be passed on to the argument 
\code{na.strings} in function \code{read.delim}.}

\item{intensityStr}{character string indicating which columns contain 
raw intensities measurements}

\item{qualColName}{character string indicating which column can be used for 
additional quality criteria when deciding between different non-unique 
protein identifiers.}

\item{nonZeroCols}{column like default qssm that should be imported and
requested to be non-zero in analyzed data}
}
\value{
list of data frames containing different
datasets
}
\description{
Import 2D-TPP dataset main function
}
\examples{
data("config_tab")
data("raw_dat_list")
dataList <- import2dMain(configTable = config_tab,
                         data = raw_dat_list,
                         idVar = "protein_id",
                         fcStr = "rel_fc_",
                         addCol = "gene_name",
                         naStrs = NA,
                         intensityStr = "signal_sum_",
                         nonZeroCols = "qusm",
                         qualColName = "qupm")
}
