% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TENxFileList-class.R
\name{TENxFileList}
\alias{TENxFileList}
\title{TENxFileList: Represent groups of files from 10X Genomic}
\usage{
TENxFileList(..., version, compressed = FALSE)
}
\arguments{
\item{...}{Typically, a file path to a tarball archive. Can be named
arguments corresponding to file paths, or a named list of file paths.}

\item{version}{character(1) The version in the tarball. See details.}

\item{compressed}{logical(1) Whether or not the file provided is compressed,
usually as \code{tar.gz} (default FALSE)}
}
\value{
Either a \code{SingleCellExperiment} or a list of imported data
}
\description{
This constructor function is meant to handle \code{.tar.gz} tarball
files from 10X Genomics.
}
\details{
These tarballs usually contain three files:
\enumerate{
\item \code{matrix.mtx.gz} - the counts matrix
\item \code{features.tsv.gz} - row metadata usually represented as \code{rowData}
\item \code{barcodes.tsv.gz} - column names corresponding to cell barcode
identifiers
If all above files are in the tarball, the import method will provide a
\code{SingleCellExperiment}. Otherwise, a simple list of imported data is given.
Note that version "3" uses 'features.tsv.gz' and version "2" uses
'genes.tsv.gz'. If known, indicate the \code{version} argument in the
\code{TENxFileList} constructor function.
}
}
\examples{

fl <- system.file(
    "extdata", "pbmc_granulocyte_sorted_3k_ff_bc_ex_matrix.tar.gz",
    package = "TENxIO", mustWork = TRUE
)

## Method 1 (tarball)
TENxFileList(fl)

## metadata before import
metadata(TENxFileList(fl))

## import() method
import(TENxFileList(fl))

## metadata after import
import(TENxFileList(fl)) |>
    metadata()

## untar to simulate folder output
dir.create(tdir <- tempfile())
untar(fl, exdir = tdir)

## Method 2 (folder)
TENxFileList(tdir)
import(TENxFileList(tdir))

## Method 3 (list of TENxFile objects)
files <- list.files(tdir, recursive = TRUE, full.names = TRUE)
names(files) <- basename(files)
filelist <- lapply(files, TENxFile)

TENxFileList(filelist, compressed = FALSE)

## Method 4 (SimpleList)
TENxFileList(as(filelist, "SimpleList"), compressed = FALSE)

## Method 5 (named arguments)
TENxFileList(
    barcodes.tsv.gz = TENxFile(files[1]),
    features.tsv.gz = TENxFile(files[2]),
    matrix.mtx.gz = TENxFile(files[3])
)

unlink(tdir, recursive = TRUE)

}
