% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TENxFileList-class.R
\docType{class}
\name{TENxFileList-class}
\alias{TENxFileList-class}
\alias{.TENxFileList}
\alias{path,TENxFileList-method}
\alias{decompress,TENxFileList-method}
\alias{import,TENxFileList,ANY,ANY-method}
\alias{metadata,TENxFileList-method}
\title{TENxFileList: A list-like representation for TENxFiles}
\usage{
\S4method{path}{TENxFileList}(object, ...)

\S4method{decompress}{TENxFileList}(manager, con, ...)

\S4method{import}{TENxFileList,ANY,ANY}(con, format, text, ...)

\S4method{metadata}{TENxFileList}(x, ...)
}
\arguments{
\item{object}{
    An object containing paths. Even though it will typically contain
    a single path, \code{object} can actually contain an arbitrary
    number of paths.
  }

\item{...}{Additional arguments (not used)}

\item{manager}{A \code{ConnectionManager} internal instance; currently not used.}

\item{con}{The connection from which data is loaded or to which data is
saved. If this is a \code{character} vector, it is assumed to be a file name and
a corresponding file connection is created and then closed after exporting
the object. If it is a \link[BiocIO:BiocFile-class]{BiocFile} derivative, the
data is loaded from or saved to the underlying resource. If missing, the
function will return the output as a character vector, rather than writing
to a connection.}

\item{format}{The format of the output. If missing and \code{con} is a
file name, the format is derived from the file extension. This argument is
unnecessary when \code{con} is a derivative of \link[BiocIO:BiocFile-class]{BiocFile}.}

\item{text}{If \code{con} is missing, this can be a character vector directly
providing the string data to import.}

\item{x}{An object of class \code{TENxFile}, \code{TENxFileList}, \code{TENxMTX}, \code{TENxH5},
\code{TENxPeaks}, \code{TENxTSV}, or derivatives}
}
\value{
A \code{TENxFileList} class object
}
\description{
This class was designed to mainly handle tarballs from
10X Genomics. The typical file extension for these tarballs is \code{.tar.gz}.
}
\details{
These tarballs usually contain three files:
\enumerate{
\item \code{matrix.mtx.gz} - the counts matrix
\item \code{features.tsv.gz} - row metadata usually represented as \code{rowData}
\item \code{barcodes.tsv.gz} - column names corresponding to cell barcode
identifiers
Note that version '2' includes \code{genes.tsv.gz} instead of \code{features.tsv.gz} in
version '3'.
}

An additional \code{ref} argument can be provided when the file contains
multiple \code{feature_type} in the file or "Type" in the \code{rowData}. By default,
the first type reported in \code{table()} is set as the \code{mainExpName} in the
\code{SingleCellExperiment} object.
}
\section{Functions}{
\itemize{
\item \code{path(TENxFileList)}: Obtain file paths for all files in the object
as a vector

\item \code{decompress(TENxFileList)}: An intermediate method for decompressing
(via untar) the contents of a \code{.tar.gz} file list

\item \code{import(con = TENxFileList, format = ANY, text = ANY)}: Recursively import files within a
\code{TENxFileList}

\item \code{metadata(TENxFileList)}: \code{metadata} method for \code{TENxFileList} objects

}}
\section{Slots}{

\describe{
\item{\code{listData}}{list() The data in list format}

\item{\code{extension}}{character() A vector of file extensions for each file}

\item{\code{compressed}}{logical(1) Whether the file is compressed as \code{.tar.gz}}

\item{\code{version}}{character(1) The version number of the tarball usually either
'2' or '3'}
}}

