% Generated by roxygen2: do not edit by hand
% Please edit documentation in
%   R/step7TopGenesOverlappingLinkedDNAMethylationSitesHeatmaps.R
\name{step7TopGenesOverlappingLinkedDNAMethylationSitesHeatmaps}
\alias{step7TopGenesOverlappingLinkedDNAMethylationSitesHeatmaps}
\title{Generate binary heatmaps displaying which of the top genes and transcription
factors share links with each of the unique regulatory element DNA
methylation sites linked to at least one top gene/TF}
\usage{
step7TopGenesOverlappingLinkedDNAMethylationSitesHeatmaps(
  TENETMultiAssayExperiment,
  geneAnnotationDataset = NA,
  hypermethGplusAnalysis = TRUE,
  hypomethGplusAnalysis = TRUE,
  topGeneNumber = 10
)
}
\arguments{
\item{TENETMultiAssayExperiment}{Specify a MultiAssayExperiment object
containing expression and methylation SummarizedExperiment objects, such as
one created by the TCGADownloader function. The object's metadata must
contain the results from the \code{step5OptimizeLinks} and
\code{step6DNAMethylationSitesPerGeneTabulation} functions.}

\item{geneAnnotationDataset}{Specify a gene annotation dataset which is
used to identify names for genes by their Ensembl IDs. The argument must be
either a GRanges object (such as one imported via \code{rtracklayer::import}) or a
path to a GFF3 or GTF file. Both GENCODE and Ensembl annotations are
supported. Other annotation datasets may work, but have not been tested.
See the "Input data" section of the vignette for information on the required
dataset format.
Specify NA to use the gene names listed in the "geneName" column of the
elementMetadata of the rowRanges of the "expression" SummarizedExperiment
object within the TENETMultiAssayExperiment object. Defaults to NA.}

\item{hypermethGplusAnalysis}{Set to TRUE to create heatmaps and tables
showing the linked RE DNA methylation sites for the top genes and TFs with
the most hypermethylated RE DNA methylation sites with G+ links. Defaults to
TRUE.}

\item{hypomethGplusAnalysis}{Set to TRUE to create heatmaps and tables
showing the linked RE DNA methylation sites for the top genes and TFs with
the most hypomethylated RE DNA methylation sites with G+ links. Defaults to
TRUE.}

\item{topGeneNumber}{Specify the number of top genes and TFs, based on the
most linked RE DNA methylation sites of a given analysis type, for which to
generate linked RE DNA methylation site heatmaps and tables. Defaults to 10.}
}
\value{
Returns the MultiAssayExperiment object given as the
TENETMultiAssayExperiment argument with an additional list
named 'step7TopGenesOverlappingLinkedDNAMethylationSitesHeatmaps' in its
metadata containing the output of this function. This list contains
\code{hypermethGplus} and/or \code{hypomethGplus} lists, as selected by the user, which
contain lists for the top overall genes and top TF genes. These lists contain
binary heatmaps displaying the top genes/TFs in the columns and the unique RE
DNA methylation sites linked to these genes in the rows, with black
indicating that the given RE DNA methylation site is linked to the given
gene. Dendrograms are included to identify blocks of RE DNA methylation sites
that are linked to similar genes. Data frames are also included which
represent the links numerically, with 1s indicating a link is present.
}
\description{
This function takes the top genes and TFs for each analysis type by number of
linked RE DNA methylation sites identified by the
\code{step6DNAMethylationSitesPerGeneTabulation} function, up to the number
specified by the user, and identifies the unique RE DNA methylation sites
linked to them, then generates two-color binary heatmaps displaying which of
the top genes and TFs the RE DNA methylation sites are linked to, as well as
data frames with that information.
}
\examples{
\dontshow{if (interactive()) withAutoprint(\{ # examplesIf}
## This example uses the example MultiAssayExperiment provided in the
## TENET.ExperimentHub package to create overlap heatmaps, and corresponding
## data frames, for the top 10 genes and TFs by number of linked hyper- and
## hypomethylated RE DNA methylation sites. Gene names will be retrieved
## from the rowRanges of the 'expression' SummarizedExperiment object in the
## example MultiAssayExperiment.

## Load the example TENET MultiAssayExperiment object
## from the TENET.ExperimentHub package
exampleTENETMultiAssayExperiment <-
    TENET.ExperimentHub::exampleTENETMultiAssayExperiment()

## Use the example dataset to create overlap heatmaps
returnValue <- step7TopGenesOverlappingLinkedDNAMethylationSitesHeatmaps(
    TENETMultiAssayExperiment = exampleTENETMultiAssayExperiment
)

## This example is similar, but creates overlap heatmaps and corresponding
## data frames for only the top 5 genes and TFs by number of linked
## hypomethylated RE DNA methylation sites.

## Load the example TENET MultiAssayExperiment object
## from the TENET.ExperimentHub package
exampleTENETMultiAssayExperiment <-
    TENET.ExperimentHub::exampleTENETMultiAssayExperiment()

## Use the example dataset to create overlap heatmaps
returnValue <- step7TopGenesOverlappingLinkedDNAMethylationSitesHeatmaps(
    TENETMultiAssayExperiment = exampleTENETMultiAssayExperiment,
    hypermethGplusAnalysis = FALSE,
    topGeneNumber = 5
)
\dontshow{\}) # examplesIf}
}
