% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/step7StatesForLinks.R
\name{step7StatesForLinks}
\alias{step7StatesForLinks}
\title{Identify which of the case samples harbor each of the identified regulatory
element DNA methylation site-gene links}
\usage{
step7StatesForLinks(
  TENETMultiAssayExperiment,
  hypermethGplusAnalysis = TRUE,
  hypomethGplusAnalysis = TRUE,
  coreCount = 1
)
}
\arguments{
\item{TENETMultiAssayExperiment}{Specify a MultiAssayExperiment object
containing expression and methylation SummarizedExperiment objects, such as
one created by the TCGADownloader function. The object's metadata must
contain the results from the \code{step2GetDifferentiallyMethylatedSites} and
\code{step5OptimizeLinks} functions.}

\item{hypermethGplusAnalysis}{Set to TRUE to analyze which case samples
harbor each hypermethylated G+ RE DNA methylation site-gene link. Defaults to
TRUE.}

\item{hypomethGplusAnalysis}{Set to TRUE to analyze which case samples
harbor each hypomethylated G+ RE DNA methylation site-gene link. Defaults to
TRUE.}

\item{coreCount}{Argument passed as the mc.cores argument to mcmapply. See
\code{?parallel::mcmapply} for more details. Defaults to 1.}
}
\value{
Returns the MultiAssayExperiment object given as the
TENETMultiAssayExperiment argument with an additional list
named 'step7StatesForLinks' in its metadata containing the output of this
function. This list contains \code{hypermethGplus} and/or \code{hypomethGplus} data
frames, as selected by the user, which contain columns for each case sample
and rows for each RE DNA methylation site-gene link for that analysis type.
A 1 at the intersection of a row and column indicates the sample harbors that
link and a 0 indicates it does not; an NA value indicates that the sample
lacks methylation data for the site or expression data for the gene.
}
\description{
This function generates data frames indicating whether each of the case
samples harbors each RE DNA methylation site-gene link from the hyper- and/or
hypomethylated G+ analysis quadrants. A given sample harbors a link if the
RE DNA methylation site in the link is hyper- and/or hypomethylated in that
sample, and if expression of the gene in the link in that sample is
significantly less than or greater than, respectively, the mean expression of
the gene in the control samples, as determined by a
Bonferroni-corrected 1-sided t-test with a p-value threshold of 0.05. This
may aid in identifying case samples for further analyses.
}
\examples{
\dontshow{if (interactive()) withAutoprint(\{ # examplesIf}
## This example uses the example MultiAssayExperiment provided in the
## TENET.ExperimentHub package to create data frames for link states between
## genes and hyper- and hypomethylated G+ RE DNA methylation sites. The
## analysis will be performed using one CPU core.

## Load the example TENET MultiAssayExperiment object
## from the TENET.ExperimentHub package
exampleTENETMultiAssayExperiment <-
    TENET.ExperimentHub::exampleTENETMultiAssayExperiment()

## Use the example dataset to perform the analysis
returnValue <- step7StatesForLinks(
    TENETMultiAssayExperiment = exampleTENETMultiAssayExperiment
)

## This example is similar, but it analyzes only hypomethylated G+ RE DNA
## methylation sites, and the analysis is performed using 8 CPU cores.

## Load the example TENET MultiAssayExperiment object
## from the TENET.ExperimentHub package
exampleTENETMultiAssayExperiment <-
    TENET.ExperimentHub::exampleTENETMultiAssayExperiment()

## Use the example dataset to perform the analysis
returnValue <- step7StatesForLinks(
    TENETMultiAssayExperiment = exampleTENETMultiAssayExperiment,
    hypermethGplusAnalysis = FALSE,
    coreCount = 8
)
\dontshow{\}) # examplesIf}
}
