% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/easyTENET.R
\name{easyTENET}
\alias{easyTENET}
\title{Run the step 1 through step 6 functions with default arguments}
\usage{
easyTENET(
  TENETMultiAssayExperiment,
  extHM = NA,
  extNDR = NA,
  consensusEnhancer = TRUE,
  consensusPromoter = FALSE,
  consensusNDR = TRUE,
  publicEnhancer = FALSE,
  publicPromoter = FALSE,
  publicNDR = FALSE,
  cancerType = NA,
  ENCODEPLS = FALSE,
  ENCODEpELS = FALSE,
  ENCODEdELS = FALSE,
  assessPromoter = FALSE,
  TSSDist = 1500,
  minCaseCount,
  coreCount = 1
)
}
\arguments{
\item{TENETMultiAssayExperiment}{Specify a MultiAssayExperiment object
containing expression and methylation SummarizedExperiment objects,
such as one created by the TCGADownloader function. Coordinates for
genes and DNA methylation sites must be included in the rowRanges
of their respective SummarizedExperiment objects and should be annotated
to the human hg38 genome.
An argument of all functions except \code{step1MakeExternalDatasets}.}

\item{extHM}{To use custom histone modification datasets, specify one or more
paths to .bed, .narrowPeak, .broadPeak, and/or .gappedPeak files containing
these datasets, or directories containing these file types. The files may
optionally be compressed (.gz/.bz2/.xz). Otherwise, specify NA or do not
specify this argument.
An argument of the \code{step1MakeExternalDatasets} function.}

\item{extNDR}{To use custom open chromatin or NDR datasets, specify one or
more paths to .bed, .narrowPeak, .broadPeak, and/or .gappedPeak files
containing these datasets, or directories containing these file types. The
files may optionally be compressed (.gz/.bz2/.xz). Otherwise, specify NA or
do not specify this argument.
An argument of the \code{step1MakeExternalDatasets} function.}

\item{consensusEnhancer}{Set to TRUE to use the consensus enhancer data
included in TENET.AnnotationHub. Defaults to TRUE.
An argument of the \code{step1MakeExternalDatasets} function.}

\item{consensusPromoter}{Set to TRUE to use the consensus promoter data
included in TENET.AnnotationHub. Defaults to FALSE.
An argument of the \code{step1MakeExternalDatasets} function.}

\item{consensusNDR}{Set to TRUE to use the consensus open chromatin (NDR)
data included in TENET.AnnotationHub. Defaults to TRUE.
An argument of the \code{step1MakeExternalDatasets} function.}

\item{publicEnhancer}{Set to TRUE to use the preprocessed publicly available
enhancer (H3K27ac) datasets included in TENET.AnnotationHub. If set to TRUE,
\code{cancerType} must be specified. Defaults to FALSE.
An argument of the \code{step1MakeExternalDatasets} function.}

\item{publicPromoter}{Set to TRUE to use the preprocessed publicly available
promoter (H3K4me3) datasets included in TENET.AnnotationHub. If set to TRUE,
\code{cancerType} must be specified. Defaults to FALSE.
An argument of the \code{step1MakeExternalDatasets} function.}

\item{publicNDR}{Set to TRUE to use the preprocessed publicly available
open chromatin (ATAC-seq, DNase-seq) datasets included in
TENET.AnnotationHub. If set to TRUE, \code{cancerType} must be specified.
Defaults to FALSE. An argument of the \code{step1MakeExternalDatasets} function.}

\item{cancerType}{If \code{publicEnhancer}, \code{publicPromoter}, and/or \code{publicNDR}
is TRUE, specify a vector of cancer types ('BLCA', 'BRCA', 'COAD',
'ESCA', 'HNSC', 'KIRP', 'LIHC', 'LUAD', 'LUSC', and/or 'THCA') to include the
public data relevant to those cancer types. Defaults to NA.
An argument of the \code{step1MakeExternalDatasets} function.}

\item{ENCODEPLS}{Set to TRUE to use the ENCODE promoter-like elements
dataset included in TENET.AnnotationHub. Defaults to FALSE.
An argument of the \code{step1MakeExternalDatasets} function.}

\item{ENCODEpELS}{Set to TRUE to use the ENCODE proximal enhancer-like
elements dataset included in TENET.AnnotationHub. Defaults to FALSE.
An argument of the \code{step1MakeExternalDatasets} function.}

\item{ENCODEdELS}{Set to TRUE to use the ENCODE distal enhancer-like
elements dataset included in TENET.AnnotationHub. Defaults to FALSE.
An argument of the \code{step1MakeExternalDatasets} function.}

\item{assessPromoter}{Set to TRUE to identify DNA methylation sites
that mark promoter regions or FALSE to identify distal enhancer regions.
Defaults to FALSE.
An argument of the \code{step2GetDifferentiallyMethylatedSites} function.}

\item{TSSDist}{Specify a positive integer distance in base pairs to any
transcription start site within which DNA
methylation sites are considered promoter DNA methylation sites. DNA
methylation sites outside this distance from any transcription start site
will be considered enhancer methylation sites. Defaults to 1500.
An argument of the \code{step2GetDifferentiallyMethylatedSites} function.}

\item{minCaseCount}{Specify the minimum number of case samples to be
considered for the hyper- and hypomethylated groups. Must be a positive
integer less than the total number of case samples.
An argument of the \code{step2GetDifferentiallyMethylatedSites} function.}

\item{coreCount}{Argument passed as the mc.cores argument to mclapply. See
\code{?parallel::mclapply} for more details. Defaults to 1.
Used by the \code{step3GetAnalysisZScores},
\code{step4SelectMostSignificantLinksPerDNAMethylationSite}, and
\code{step5OptimizeLinks} functions.}
}
\value{
Returns the created MultiAssayExperiment object containing data from
all step 1 through 6 functions.
}
\description{
This function runs the main six TENET functions (\code{step1MakeExternalDatasets},
\code{step2GetDifferentiallyMethylatedSites}, \code{step3GetAnalysisZScores},
\code{step4SelectMostSignificantLinksPerDNAMethylationSite}, \code{step5OptimizeLinks},
and \code{step6DNAMethylationSitesPerGeneTabulation}) in sequence on the specified
TENETMultiAssayExperiment object. Arguments for this function generally
reflect the arguments of the component functions without clearly defined
defaults, with the exception of the \code{step1MakeExternalDatasets} function
where all arguments have been included to support all available options to
define regions with relevant regulatory elements. All remaining arguments of
the component functions are set to their default values.
}
\examples{
\dontshow{if (interactive()) withAutoprint(\{ # examplesIf}
## This example creates a dataset of putative enhancer regulatory elements
## from consensus datasets and breast invasive carcinoma-relevant sources
## collected in the TENET.AnnotationHub package, then runs the step 2 through
## step 6 TENET functions analyzing RE DNA methylation sites in potential
## enhancer elements located over 1500 bp from transcription start sites
## listed for genes and transcripts in the GENCODE v36 human genome
## annotations, using a minimum case sample count of 5 and one CPU core
## to perform the analysis.

## Load the example TENET MultiAssayExperiment object from the
## TENET.ExperimentHub package
exampleTENETMultiAssayExperiment <-
    TENET.ExperimentHub::exampleTENETMultiAssayExperiment()

## Use the example TENET MultiAssayExperiment to run the step 1 through
## step 6 TENET functions
returnValue <- easyTENET(
    TENETMultiAssayExperiment = exampleTENETMultiAssayExperiment,
    extHM = NA,
    extNDR = NA,
    publicEnhancer = TRUE,
    publicNDR = TRUE,
    cancerType = "BRCA",
    ENCODEdELS = TRUE,
    minCaseCount = 5
)

## This example creates a dataset of putative promoter regulatory elements
## using BED-like files contained in the user's working directory, consensus
## NDR and promoter regions, and regions with promoter-like signatures from
## the ENCODE SCREEN project, but excluding cancer type-specific public
## datasets. This dataset is then used to analyze DNA methylation sites in
## promoter elements within 2000 bp of all transcription start sites
## provided in the MultiAssayExperiment only, identifying alterations found
## in at least 10 samples, and using 8 CPU cores to perform the analysis.

## Load the example TENET MultiAssayExperiment object from the
## TENET.ExperimentHub package
exampleTENETMultiAssayExperiment <-
    TENET.ExperimentHub::exampleTENETMultiAssayExperiment()

## Use the example TENET MultiAssayExperiment to run the step 1 through
## step 6 TENET functions
returnValue <- easyTENET(
    TENETMultiAssayExperiment = exampleTENETMultiAssayExperiment,
    extHM = ".",
    extNDR = ".",
    consensusEnhancer = FALSE,
    consensusPromoter = TRUE,
    ENCODEPLS = TRUE,
    assessPromoter = TRUE,
    TSSDist = 2000,
    minCaseCount = 10,
    coreCount = 8
)
\dontshow{\}) # examplesIf}
}
