% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GenericFunctions.R
\name{counts}
\alias{counts}
\alias{counts,TCA-method}
\alias{counts<-,TCA-method}
\title{Extracts counts of a TCA object.}
\usage{
\S4method{counts}{TCA}(object, normalization = "none", lib.norm = TRUE, log = FALSE, ...)

\S4method{counts}{TCA}(object) <- value
}
\arguments{
\item{object}{a \code{TCA} object.}

\item{normalization}{character string giving the normalization method.
Options are "\code{none}" (original raw counts), "\code{cpm}" (counts
per million),
"\code{rpkm}" (reads per kilobase per million).}

\item{lib.norm}{logical indicating whether or not use effective library
size (see Details below) when \code{normalization} is "\code{cpm}" or
"\code{rpkm}".}

\item{log}{logical if \code{TRUE}, the returned value will be on a log2
scale.}

\item{...}{additional arguments passed to \code{\link{cpm}} or
\code{\link{rpkm}} in the edgeR package.}

\item{value}{an integer matrix.}
}
\value{
An integer matrix
}
\description{
\code{counts} extract raw read counts  stored in a \code{TCA} object 
or compute normalized counts from the raw counts.
}
\details{
when calculating normalized counts, library size can be rescaled
to minimize the log-fold changes between samples for most genomic features
(e.g. genes, binding sites) by multiplying a scale factor. The rescaled
library size is called effective library size. In this function, the scale
factor is calculated using the weighted trimmed mean of M-values (TMM,
Robinson et al (2010))

If log2 values are computed, a small count would be added to avoid logarithm 
of zero. The actual added count will be scaled according to the library size,
for details see \code{\link{addPriorCount}} in the edgeR package
when not specified, the prior count is set to 0.25 by default.
}
\examples{
data(tca_ATAC)
c <- counts(tca_ATAC)
# normalized counts table
c_norm <- counts(tca_ATAC, normalization='rpkm')
}
\references{
Robinson, M. D., & Oshlack, A. (2010). A scaling normalization method for
differential expression analysis of RNA-seq data. Genome biology, 11(3), 1.
}
\author{
Mengjun Wu
}
