% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/query.R
\name{GDCquery_ATAC_seq}
\alias{GDCquery_ATAC_seq}
\title{Retrieve open access ATAC-seq files from GDC server}
\usage{
GDCquery_ATAC_seq(tumor = NULL, file.type = NULL)
}
\arguments{
\item{tumor}{a valid tumor}

\item{file.type}{Write maf file into a csv document}
}
\value{
A data frame with the maf file information
}
\description{
Retrieve open access ATAC-seq files from GDC server
 https://gdc.cancer.gov/about-data/publications/ATACseq-AWG
 Manifest available at: https://gdc.cancer.gov/system/files/public/file/ATACseq-AWG_Open_GDC-Manifest.txt
}
\examples{
 query <- GDCquery_ATAC_seq(file.type = "txt")
\dontrun{
   GDCdownload(query)
}
query <- GDCquery_ATAC_seq(tumor = "BRCA",file.type = "bigWigs")
\dontrun{
   GDCdownload(query,method = "client")
}
}
