% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootstrap.R
\name{signatureROCplot}
\alias{signatureROCplot}
\title{Create an array of ROC plots to compare signatures.}
\usage{
signatureROCplot(
  inputData,
  annotationData,
  signatureColNames,
  annotationColName,
  scale = FALSE,
  choose_colors = c("cornflowerblue", "gray24"),
  name = "Signatures",
  nrow = NULL,
  ncol = NULL
)
}
\arguments{
\item{inputData}{an input data object. It should either be of the class
\code{SummarizedExperiment} and contain the profiled signature data and
annotation data as columns in the \code{colData}, or alternatively be of the
classes \code{data.frame} or \code{matrix} and contain only the gene
expression data. Required.}

\item{annotationData}{a \code{data.frame} or \code{matrix} of annotation data,
with one column. Only required if \code{inputData} is a \code{data.frame} or
\code{matrix} of signature data.}

\item{signatureColNames}{a \code{vector} of the column names of \code{inputData}
that contain the signature data. If \code{inputData} is a
\code{SummarizedExperiment} object, these are the column names of the
object \code{colData}.}

\item{annotationColName}{a character string naming the column name in the
\code{colData} that contains the annotation data to be used in making the
boxplot. Only required if inputData is a \code{SummarizedExperiment} object.}

\item{scale}{logical. Setting \code{scale = TRUE} scales the signature data.
The default is \code{FALSE}.}

\item{choose_colors}{a \code{vector} of length 2 defining the colors to be used
in the ROC plots. The default is \code{c("cornflowerblue", "gray24")}.}

\item{name}{a character string giving the title of the boxplot. The default
is \code{"Signatures"}.}

\item{nrow}{integer giving the number of rows in the resulting array.}

\item{ncol}{integer giving the number of columns in the resulting array.}
}
\value{
An array of ROC plots.
}
\description{
Create an array of ROC plots to compare signatures.
}
\examples{
# Run signature profiling
 choose_sigs <- subset(TBsignatures,
                       !(names(TBsignatures) \%in\% c("Lee_4", "Roe_OD_4")))[c(1,2)]
 prof_indian <- runTBsigProfiler(TB_indian, useAssay = "logcounts",
                                 algorithm = "ssGSEA",
                                 signatures = choose_sigs,
                                 parallel.sz = 1)

# Create ROC plots
signatureROCplot(prof_indian, signatureColNames = names(choose_sigs),
                 annotationColName = "label")

}
