% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OriginalModel.R
\name{.OriginalModel_NoRetraining}
\alias{.OriginalModel_NoRetraining}
\title{TB gene signatures that do not require retraining.}
\usage{
.OriginalModel_NoRetraining(input, useAssay, geneSignaturesName, BPPARAM)
}
\arguments{
\item{input}{A SummarizedExperiment object with gene symbols as the assay row
names.}

\item{useAssay}{A character string or an integer specifying the assay in the
\code{input}. Default is the first assay in the assay list.
Used for the test SummarizedExperiment object. Default is \code{1}, indicating the
first assay in the \code{input}.}

\item{geneSignaturesName}{A character string/vector specifying the signature
of interest. If \code{any(geneSignaturesName == "") == TRUE}, it will run all
available gene signatures' original models.}

\item{BPPARAM}{An instance inherited from \code{\link[BiocParallel]{bplapply}}.}
}
\value{
A SummarizedExperiment object with predicted scores for each sample
obtained from the signature's original model.
}
\description{
A function to obtain predicted score for TB gene signatures that do not need to be retrained.
}
\details{
Anderson_42 and Anderson_OD_51 used difference of sums to calculate
prediction scores. Difference of sums is obtained by subtracting the sum of
the expression of genes within signatures that are down-regulated from the
sum of the expression of genes that are up-regulated within signatures.
Kaforou_27, Kaforou_OD_44, and Kaforou_OD_53 used difference of arithmetic
means to calculate prediction scores.
Sweeney_OD_3 used difference of arithmetic mean to calculate prediction score.
}
