% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{common_sigAnnotData}
\alias{common_sigAnnotData}
\title{Annotation information for published TB signatures.}
\format{
data.frame
}
\source{
See \code{?TBcommon} for reference information.
}
\usage{
common_sigAnnotData
}
\description{
A \code{data.frame} of annotation information for published tuberculosis
signatures. This table differs from that of \code{sigAnnotData} as it
refers to signatures via the name given in scientific publications, and
via a consistent naming system otherwise.
Currently, this table includes two variables, \code{disease} and
\code{tissue type}.
}
\details{
The \code{disease} variable indicates whether the signature was developed
to distinguish TB from LTBI ("Disease"), TB from some combination of other
diseases and possibly LTBI ("OD"), TB from Human Immunodeficiency Virus ("HIV"),
TB from pneumonia ("PNA"), or identify risk of progression to TB ("RISK"),
risk of TB treatment failure ("FAIL"), or classify treatment responses
(i.e., failures from cures, "RES").

The \code{tissue type} variable denotes whether the signature was developed
using samples of either whole blood/paxgene or peripheral blood mononuclear
cells (PBMCs). Due to the manipulation of cells inherently required to obtain
PBMCs, many scientists prefer to use only whole blood samples for analysis.
}
\examples{
data("common_sigAnnotData")
}
\keyword{datasets}
