% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TsIO_classes.R
\docType{class}
\name{TsIOList-class}
\alias{TsIOList-class}
\alias{TsIOList}
\alias{sequence_id,TsIOList-method}
\alias{target_sequence,TsIOList-method}
\alias{sequence_template,TsIOList-method}
\alias{target_annot,TsIOList-method}
\alias{tapseq_primers,TsIOList-method}
\alias{pcr_products,TsIOList-method}
\title{TsIOList class}
\usage{
TsIOList(...)

\S4method{sequence_id}{TsIOList}(x)

\S4method{target_sequence}{TsIOList}(x)

\S4method{sequence_template}{TsIOList}(x)

\S4method{target_annot}{TsIOList}(x)

\S4method{tapseq_primers}{TsIOList}(x)

\S4method{pcr_products}{TsIOList}(x)
}
\arguments{
\item{...}{Multiple TsIO objects from which a TsIOList object should be created.}

\item{x}{A \code{TsIOList} object.}
}
\value{
A \code{TsIOList} object.
}
\description{
TsIOList class is a container to store multiple \code{\link[TAPseq:TsIO-class]{TsIO}} objects.
This enables storing of Primer3 input and output for multiple target genes.
}
\section{Methods (by generic)}{
\itemize{
\item \code{sequence_id(TsIOList)}: Get sequence_id

\item \code{target_sequence(TsIOList)}: Get target_sequence

\item \code{sequence_template(TsIOList)}: Create sequence_template

\item \code{target_annot(TsIOList)}: Get target_annot

\item \code{tapseq_primers(TsIOList)}: Get tapseq_primers

\item \code{pcr_products(TsIOList)}: Get pcr_products

}}
\examples{
# get example transcript sequences
data("chr11_truncated_txs_seq")
txs_seqs <- chr11_truncated_txs_seq[1:2]
txs_ids <- names(txs_seqs)

# 10x beads-oligo-dt sequence
beads_oligo <- "CTACACGACGCTCTTCCGATCTNNNNNNNNNNNNNNNNNNNNNNNNNNNNTTTTTTTTTTTTTTTTTTTTTTTTTTTTTT"

# reverse primer used in all PCR reactions
reverse_primer <- "CTACACGACGCTCTTCCGATCT"

# create TsIO objects
tsio1 <- TsIO(sequence_id = txs_ids[1], target_sequence = txs_seqs[[1]],
              beads_oligo = beads_oligo, reverse_primer = reverse_primer,
              product_size_range = c(350, 500))

tsio2 <- TsIO(sequence_id = txs_ids[2], target_sequence = txs_seqs[[2]],
              beads_oligo = beads_oligo, reverse_primer = reverse_primer,
              product_size_range = c(350, 500))

# create TsIOList object
obj <- TsIOList(tsio1 = tsio1, tsio2 = tsio2)

# it's noteworthy to mention that when creating a TsIOList from a DNAStringSet of target
# sequences, it's easier to use TAPseqInput()
?TAPseqInput

# as with TsIO objects, some values can be accessed using accessor functions
sequence_template(obj)
}
\seealso{
\link[TAPseq:TsIO-class]{TsIO}
}
