#' Chromosome 22 combined intrachromosomal primary contact matrix from
#' Rao et al. 2014.
#'
#' A 704x704 contact matrix from the GM12878 cell line (50kb Resolution)
#'
#' @format A data frame with 704 rows and 704 variables:
#' @source \url{https://www.ncbi.nlm.nih.gov/geo/query/acc.cgi?acc=GSE63525}
"rao_chr22_prim"

#' Chromosome 22 combined intrachromosomal replicate contact matrix from
#' Rao et al. 2014.
#'
#' A 704x704 contact matrix from the GM12878 cell line (50kb Resolution)
#'
#' @format A data frame with 704 rows and 704 variables:
#' @source \url{https://www.ncbi.nlm.nih.gov/geo/query/acc.cgi?acc=GSE63525}
"rao_chr22_rep"

#' Chromosome 22 time-varying contact matrices from Rao et al. 2017.
#'
#' Four 704x704 contact matrices representing 20, 40, 60, 180 minutes since
#' auxin treatment and removal from the HCT-116 cell line (50kb Resolution)
#'
#' @format A data frame with 704 rows and 704 variables:
#' @source \url{https://www.ncbi.nlm.nih.gov/geo/query/acc.cgi?acc=GSE104334}
"time_mats"
