\name{outputLib}
\alias{outputLib}
\title{output a spectrum library into a PeakView format file}
\usage{
outputLib(dat, filename = "NewLib.txt", format = c("peakview", "openswath"),
  nodup = TRUE)
}
\arguments{
\item{dat}{A data frame of a spectrum library}

\item{filename}{A character string for the name of the output.}

\item{format}{A character string representing the output format. One of
"peakview" (default) and "openswath".}

\item{nodup}{A logic value, indicating if remove duplicated 
sprectrum (default)}
}
\value{
a file with the specified file name (lib.txt as default) will be
saved under the current working directory
}
\description{
output a spectrum library into a PeakView format file
}
\examples{
file <- paste(system.file("files",package="SwathXtend"),"Lib1.txt",sep="/")
dat <- readLibFile(file)
outputLib(dat)
}

