\name{mlrrep}
\alias{mlrrep}
\title{
Function to do mlr normalizatiopn on a matrix of replicates
}
\description{
Calculate all pairwise ratios, log-transform them, find the least variable replicate.
}
\usage{
mlrrep(mat)
}
\arguments{
  \item{mat}{
	Data matrix with replicates as columns
}
}
\details{
}
\value{
	\item{mat.norm}{Normalized data matrix; matrix assumed positive}
	\item{wdmat}{Square matrix of half peak widths for each ratio of replicates of size ncol(mat)}
	\item{nfmat}{Square matrix of normalization factors for each ratio of replicates of size ncol(mat)}
	\item{idx}{Index of replicate to be used as denominator yielding smallest widths}
}
\references{
}
\author{
}
\note{
}
\seealso{
\code{\link{mlr}}, \code{\link{mlrGroup}}
}
\examples{
# Example using the iris data
mlrrep(iris[,-5])

# random data
mat = exp(matrix(rnorm(1000),ncol=4))
res = mlrrep(mat) 
layout(matrix(1:2, nrow=1))
boxplot(log(res$mat.norm))
boxplot(log(mat))
}

