\name{checkQuality}
\alias{checkQuality}
\title{Checking for the integration quality of two libraries}
\usage{
checkQuality(datBaseLib, datExtLib, ...)
}
\arguments{
\item{datBaseLib}{a data frame of the base library}

\item{datExtLib}{a data frame of the add-on library}

\item{\dots}{Additional parameters to pass in}

}
\value{
A list of quality indicators, including squared retention time (RT)
correlation coefficient, root mean squared errors of RT residuals, 
 and median of relative ion intensity correlation coefficient
}
\description{
Checking for the integration quality of two libraries
}
\examples{
libfiles <- paste(system.file("files",package="SwathXtend"),
   c("Lib2.txt","Lib3.txt"),sep="/")
datBaseLib <- readLibFile(libfiles[1])
datExtLib <- readLibFile(libfiles[2])
res <- checkQuality(datBaseLib, datExtLib)
}

