\name{canonicalFormat}
\alias{canonicalFormat}
\title{Standardise a sprectrum library data frame}
\usage{
canonicalFormat(dat, format = c("peakview", "openswath"))
}
\arguments{
\item{dat}{a data frame of a spectrum library}

\item{format}{a character string, representing the format of the input
spectrum library. One of "peakview" (default) and "openswath"
}
}
\description{
Standardise a sprectrum library data frame
}
\value{
a data frame of the library in canonical format
}
\examples{
file <- paste(system.file("files",package="SwathXtend"),"Lib1.txt",sep="/")
dat <- read.delim2(file,sep="\\t",stringsAsFactor = FALSE, header=TRUE)
dat <- try(canonicalFormat(dat, format = "peakview"))
}

