
\name{buildSpectraLibPair}
\alias{buildSpectraLibPair}
\title{Build a spectra library by integrating a pair of spectrum libraries}
\usage{
buildSpectraLibPair(baseLib, extLib, hydroIndex, method = c("time", "hydro",
  "hydrosequence"), includeLength = FALSE, labelBase = NA, labelAddon = NA,
  formatBase = c("peakview", "openswath"), formatExt = c("peakview",
  "openswath"), outputFormat = c("peakview", "openswath"),
  outputFile = "extendedLibrary.txt", plot = FALSE,
  clean = TRUE, merge = TRUE, ...)
}
\arguments{
\item{baseLib}{a base library data frame or file}

\item{extLib}{an external/addon library data frame or file}

\item{hydroIndex}{a data frame or file containing peptide hydrophobicity index}

\item{method}{a character string to specify the RT alignment method. One
of "time" (default), "hydro" and "hydrosequence" can be selected.}

\item{includeLength}{a logic value representing if include peptide
length as a feature for predicting retention time. Only applicable
when method is "hydro".}

\item{labelBase}{a character string to specify the labels of proteins from the base library}

\item{labelAddon}{a character string to specify the labels of proteins from the addon library}

\item{formatBase}{a character string denoting the file format of 
base library file. One of "peakview" (default) and "opensswath"}

\item{formatExt}{a character string denoting the file format of 
addon library file. One of "peakview" (default) and "opensswath"}

\item{outputFormat}{a character string denoting the file format of 
the output integrated library. One of "peakview" (default) and "openswath"}

\item{outputFile}{A character string to specify the sepctra library created}

\item{plot}{a logic value, representing if plots during processing
will be plotted or not}

\item{clean}{a logic value, representing if the input libraries will be
cleaned before integration. Default value is True.}

\item{merge}{a logic value, representing if the output will be the merged
library (default) or the adjusted add-on library.}

\item{\dots}{Additional parameters to pass in.}

}


\value{
A data frame of the integrated spectrum library
}
\description{
Build a spectra library by integrating a pair of spectrum libraries
}
\examples{
libfiles <- paste(system.file("files",package="SwathXtend"),
c("Lib2.txt","Lib3.txt"),sep="/")
Lib2_3 <- buildSpectraLibPair(libfiles[1], libfiles[2],  
outputFormat="peakview", clean=TRUE, nomod=TRUE, nomc=TRUE)
}

