\name{applyttest}
\alias{applyttest}
\title{
Utility to apply a t-test to all rows of a matrix
}
\description{
Generate fold change and t-test p-value for all rows of a data matrix
}
\usage{
applyttest(mat, Group, doLogs = TRUE, numerator = levels(Group)[1])
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{mat}{
	Matrix containing data, possibly with missing values
}
  \item{Group}{
	Group with two levels of length equal to the number of matrix columns
}
  \item{doLogs}{
	True/false, log data before applying test
}
  \item{numerator}{
	The level of the group used as numerator for the fold change, by default the first one
}
}
\details{
}
\value{
Data frame with two values, t-test p-value and fold change.
}
\references{
}
\author{
}
\note{
}

\seealso{
\code{\link{applyttestPep}}
}
\examples{
mat = matrix(rnorm(600), nrow=100)
mat[1:20, 1:3] = 3+mat[1:20, 1:3] # create some differences
mat[30, 1:3] = NA # and some missing values
mat[100,] = NA


applyttest(mat, Group = rep(c("A", "B"), each=3), doLogs=FALSE)
applyttest(abs(mat), Group = rep(c("A", "B"), each=3), doLogs=TRUE)


}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{ ~kwd1 }
\keyword{ ~kwd2 }% __ONLY ONE__ keyword per line
