
###############################################################################
#' Checking for the integration quality of two libraries
#' @param datBaseLib a data frame of the base library 
#' @param datExtLib a data frame of the add-on library 
#' @return A list of quality indicators, including squared retention time (RT)
#' correlation coefficient, root mean squared errors of RT residuals, 
#'  and median of relative ion intensity correlation coefficient
#' @examples 
#' libfiles <- paste(system.file("files",package="SwathXtend"),
#'    c("Lib2.txt","Lib3.txt"),sep="/")
#' datBaseLib <- readLibFile(libfiles[1])
#' datExtLib <- readLibFile(libfiles[2])
#' res <- checkQuality(datBaseLib, datExtLib)
###############################################################################

checkQuality <- function(datBaseLib, datExtLib, ...)
{
  
  list.datLibs <- try(splitLib(datBaseLib, datExtLib))
  
  
  if(inherits(list.datLibs,"try-error"))
    stop("Error with splitting datExtLib")
  
  datExtLibCommPart <- list.datLibs[["ExtCommon"]]
  datBaseCommPart <- list.datLibs[["BaseCommon"]]
  

  rtcorsqr <- try(computeRTCor(datBaseCommPart,datExtLibCommPart, ...))
  if(inherits(rtcorsqr,"try-error"))
    stop("Error with computeRTCor")
  
  ioncors<- try(computeRIICor(datBaseCommPart,datExtLibCommPart, ...))
  if(inherits(ioncors,"try-error"))
    stop("Error with computeRIICor")

  
  
  ioncormedian <- median(ioncors)
  
  list(RT.corsqr=rtcorsqr$RT.cor , RT.RMSE=rtcorsqr$RMSE, RII.cormedian= ioncormedian)
}