              

buildSpectraLibPair<-function(baseLib,extLib, hydroIndex,
                           method = c("time", "hydro", "hydrosequence"),
                           includeLength = FALSE,
                           labelBase = NA,
                           labelAddon = NA,
                           formatBase = c("peakview", "openswath"),
                           formatExt = c("peakview", "openswath"),
                           outputFormat = c("peakview", "openswath"),
                           outputFile = "extendedLibrary.txt", 
                           plot = FALSE, 
                           clean = TRUE, 
                           merge = TRUE, ...)
{
  
  if(!is.data.frame(baseLib)){	
	  datBaseLib <- try(readLibFile(baseLib, format = formatBase, clean=clean, ...))
	  
	  if(inherits(datBaseLib, "try-error"))
	  stop(paste("Error with reading", baseLib))  
	} else {
		datBaseLib <- baseLib
	}
  if(!is.data.frame(extLib)){  
  datExtLib <- try(readLibFile(extLib, format = formatExt, clean=clean, ...))
  
  if(inherits(datExtLib,"try-error"))
    stop(paste("Error with reading", extLib))
  
  } else {
		datExtLib <- extLib
	}
  

  
  datBaseLib <- try(normalise(datBaseLib))
  
  if(inherits(datBaseLib,"try-error"))
	stop("Error with normalising datBaseLib")	

  datExtLib <- try(normalise(datExtLib))
  

  if(inherits(datExtLib,"try-error"))
	  stop("Error with normalising datExtLib")
	
  ## split datExtLib into common and new  
  list.datLibs <- try(splitLib(datBaseLib, datExtLib, 
                               nomod=list(...)[['nomod']]))
  

  if(inherits(list.datLibs,"try-error"))
	  stop("Error with splitting datExtLib")
	
  datExtLibCommPart <- list.datLibs[["ExtCommon"]]
  datExtLibNewPart <- list.datLibs[["ExtNew"]]
  datBaseCommPart <- list.datLibs[["BaseCommon"]]
 
  if(plot) 
    pall<-try(plotAll(datBaseLib, datExtLib, parseAcc=TRUE))

  

  if(nrow(datBaseCommPart[!duplicated(datBaseCommPart$stripped_sequence),]) < 20)
  {  
    warning("common peptides are less than 20. ") 
  }
  
	method <- match.arg(method)
  if(method == "time"){
    
  
    datExtLibNewPart <- try(predictRT(datBaseCommPart,
                                     datExtLibCommPart, 
                                      datExtLibNewPart,nomod=list(...)[['nomod']]))
    if(inherits(datExtLibNewPart,"try-error"))
      stop("Error with predictRT")
  } else if (grepl("hydro",method)) {
	if(!is.data.frame(hydroIndex)){
    datHydroIndex <- try(readLibFile(hydroIndex, type="Hydro"))
	
	if(inherits(datHydroIndex, "try-error"))
		stop("Error with reading hydroindex file")
	} else {
		datHydroIndex <- hydroIndex
	}
    
    datExtLibNewPart <- try(alignRTbyHydro(datBaseLib,
                                           datExtLibNewPart, 
                                           datHydroIndex,
                                           method=method,
                                           includeLength=includeLength))
    if(inherits(datExtLibNewPart,"try-error"))
      stop("Error with alignRTbyHydro")
  } else stop(paste("Unknow method ", method))
      

  
  ## RE-GROUPING by common uniprot accession

  datBaseCommPart <- libraryFormat(datBaseCommPart)
  
  datBaseLib <- libraryFormat(datBaseLib)
  
  
  datExtLibNewPart <- libraryFormat(datExtLibNewPart)
  
  # if(consolidateAccession)
  # datExtLibNewPart <- 
    # consolidateAccession(datBaseLib, datExtLibNewPart)
  

  ## Merge base with aligned external new part
  
  datExtLibNewPart = libraryFormat(datExtLibNewPart)  
  
  if(!is.na(labelBase)){
    datBaseLib$uniprot_id <- paste(datBaseLib$uniprot_id, labelBase, sep="_")
  }
  
  if(!is.na(labelAddon)){
    datExtLibNewPart$uniprot_id <- paste(datExtLibNewPart$uniprot_id, labelAddon, sep="_")
  }
  
  res <- datExtLibNewPart
  
  if(merge) {
    datlib.fin = rbind(datBaseLib,datExtLibNewPart)
    
    
    datlib.fin = libraryFormat(datlib.fin)
    
    outputLib(datlib.fin, filename=outputFile, format=outputFormat)
      
    res <- datlib.fin
  }
  
  res
 
}  
  