% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adjAF.R
\name{adjAF_calc}
\alias{adjAF_calc}
\title{adjAF_calc}
\usage{
adjAF_calc(data, reference, observed, pi.target, pi.observed)
}
\arguments{
\item{data}{dataframe of unadjusted allele frequency for observed group, K-1 reference group allele frequencies for N SNPs}

\item{reference}{character vector of the column names for K-1 reference groups. The name of the last reference group is not included as that group is not used to estimate the adjusted allele frequencies.}

\item{observed}{character value for the column name of observed data group}

\item{pi.target}{numeric vector of the mixture proportions for K reference groups in the target sample or subject. The order must match the order of the reference columns with the last entry matching the missing reference group.}

\item{pi.observed}{numeric vector of the mixture proportions for K reference groups for the observed group. The order must match the order of the reference columns with the last entry matching the missing reference group.}
}
\value{
pi: table of input reference groups, pi.observed, and pi.target

observed.data: name of the data column for the observed group from which adjusted allele frequency is estimated

Nsnps: number of SNPs for which adjusted AF is estimated

adjusted.AF: data frame of original data with an appended column of adjusted allele frequencies
}
\description{
Helper function for calculating allele frequencies for heterogeneous populations in genetic data given proportion of reference groups
}
