\name{ParallelParam}
\Rdversion{1.1}
\docType{class}
\alias{ParallelParam-class}
\alias{ParallelParam}
\alias{ParallelRegister-class}
\alias{MulticoreParam-class}
\alias{MulticoreParam}
\alias{register}

\title{Classes to configure parallel evaluation}

\description{

  Configure and register parallel calculations, e.g., for
  \code{\link{Team}} evaluation.

}

\usage{
MulticoreParam(size = getOption("mc.cores", 2L),
    mc.set.seed = TRUE, ...)
register(param)
}

\arguments{

  \item{size}{The number of members in the parallel cluster.}

  \item{mc.set.seed}{\code{logical(1)}; see \code{?mcparallel} on unix
    platforms.}

  \item{param}{A \code{ParallelParam} instance, such as generated by
    \code{MulticoreParam()}.}

  \item{...}{Additional arguments, e.g., \code{verbose}, passed to the
  \code{Streamer} class.}

}

\section{Constructors}{
  Use \code{MulticoreParam} to construct instances of this class.
}

\section{Methods}{
  \describe{

    \item{register}{Invoked with an argument \code{param} stores the
      \code{param} for use in subsequent parallel computation. Use
      \code{NULL} to clear the register. The function returns,
      invisibly, the previously registered parameter instance, if any.}

  }

}

\section{Internal Class Fields and Methods}{

  Internal fields of this class are are described with, e.g.,
  \code{getRefClass("MulticoreParam")$fields}.

  Internal methods of this class are described with
  \code{getRefClass("MulticoreParam")$methods()} and
  \code{getRefClass("MulticoreParam")$help()}.

}

\author{Martin Morgan \url{mtmorgan@fhcrc.org}}

\seealso{

  \code{\link{Team}} to apply one function in parallel,
  \code{\link{DAGTeam}} to evaluate functions whose dependencies are
  represented as directed acyclic graphs.

}

\examples{
if (.Platform$OS.type != "windows") {
    oparam <- register()       ## previous setting
    param <- MulticoreParam()  ## default multicore settings
    register(param)            ## register for future use, e.g,. Team
    register(oparam)           ## reset original
}
}

\keyword{classes}
