% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/findArtifacts.R
\name{findArtifacts}
\alias{findArtifacts}
\title{Identify and annotate artifacts in spatial transcriptomics data}
\usage{
findArtifacts(
  spe,
  mito_percent = "expr_chrM_ratio",
  mito_sum = "expr_chrM",
  samples = "sample_id",
  n_order = 5,
  shape = "hexagonal",
  log = TRUE,
  name = "artifact",
  var_output = TRUE
)
}
\arguments{
\item{spe}{A SingleCellExperiment object.}

\item{mito_percent}{The column name representing the mitochondrial percent.
Default is 'expr_chrM_ratio'.}

\item{mito_sum}{The column name representing sum mitochondrial expression.
Default is 'expr_chrM'.}

\item{samples}{The column name representing sample IDs. Default is
'sample_id'.}

\item{n_order}{The number of orders for local mito variance calculation.
Default is 5.}

\item{shape}{The shape of the neighborhood for local variance calculation.
Can be either 'hexagonal' or 'square'. Default is 'hexagonal'.}

\item{log}{Logical, indicating whether to log1p transform mito_percent.
Default is TRUE.}

\item{name}{Prefix for the local variance column names. Default is
'artifact'.}

\item{var_output}{Logical, indicating whether to include local variances in
the output. Default is TRUE.}
}
\value{
Returns the modified SingleCellExperiment object with artifact
annotations.
}
\description{
This function identifies and annotates potential artifacts in spatial
transcriptomics data. Artifacts are detected based on local mito variance,
and the results are added to the original
SpatialExperiment (sce) object.
}
\examples{
library(SpotSweeper)
library(SpatialExperiment)
library(escheR)

data(DLPFC_artifact)
spe <- DLPFC_artifact

# find artifacts
spe <- findArtifacts(spe,
    mito_percent = "expr_chrM_ratio",
    mito_sum = "expr_chrM",
    n_order = 2, # 5 recommended, using 2 for time
    shape = "hexagonal",
    name = "artifact"
)


}
\seealso{
\code{\link{localVariance}}
}
