% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/biased_spots.R
\docType{data}
\name{biased_spots}
\alias{biased_spots}
\title{Biased Spots Data}
\format{
A \code{data.frame} with the following columns:
\describe{
\item{row}{Integer. The row position of a biased spot within the spatial grid.}
\item{col}{Integer. The column position of a biased spot within the spatial grid.}
\item{barcode}{Character. A unique identifier corresponding to the spatial transcriptomics barcode of the biased spot.}
}
}
\source{
The \code{biased_spots.rds} file was generated in the analysis of local outliers.
See https://github.com/boyiguo1/Manuscript-SpotSweeper/blob/main/code/03_Visium/figure_3.R for more details.
}
\usage{
data(biased_spots)
}
\description{
The \code{biased_spots} dataset is a \code{data.frame} containing information about specific
spatial spots identified as technical outliers in spatial transcriptomics experiments.
Each entry represents a biased spot characterized by its spatial coordinates
(row and column) and a unique barcode. This dataset is utilized by the
\code{flagVisiumOutliers} function to flag and exclude these outlier spots from
downstream analyses, thereby enhancing data quality and reliability.
}
\examples{
data(biased_spots)
}
\keyword{datasets}
