% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Spectra-functions.R
\name{chunkapply}
\alias{chunkapply}
\title{Apply a function stepwise to chunks of data}
\usage{
chunkapply(x, FUN, ..., chunkSize = 1000L, chunks = factor())
}
\arguments{
\item{x}{object to which \code{FUN} should be applied. Can be any object that
supports \code{split}.}

\item{FUN}{the function to apply to \code{x}.}

\item{...}{additional parameters to \code{FUN}.}

\item{chunkSize}{\code{integer(1)} defining the size of each chunk into which \code{x}
should be splitted.}

\item{chunks}{optional \code{factor} or length equal to \code{length(x)} defining the
chunks into which \code{x} should be splitted.}
}
\value{
Depending on \code{FUN}, but in most cases a vector/result object of
length equal to \code{length(x)}.
}
\description{
\code{chunkapply()} splits \code{x} into chunks and applies the function \code{FUN} stepwise
to each of these chunks. Depending on the object it is called, this
function might reduce memory demand considerably, if for example only the
full data for a single chunk needs to be loaded into memory at a time (e.g.,
for \code{Spectra} objects with on-disk or similar backends).
}
\examples{

## Apply a function (`sqrt`) to each element in `x`, processed in chunks of
## size 200.
x <- rnorm(n = 1000, mean = 500)
res <- chunkapply(x, sqrt, chunkSize = 200)
length(res)
head(res)

## For such a calculation the vectorized `sqrt` would however be recommended
system.time(sqrt(x))
system.time(chunkapply(x, sqrt, chunkSize = 200))

## Simple example splitting a numeric vector into chunks of 200 and
## aggregating the values within the chunk using the `mean`. Due to the
## `unsplit` the result has the same length than the input with the mean
## value repeated.
x <- 1:1000
res <- chunkapply(x, mean, chunkSize = 200)
length(res)
head(res)
}
\author{
Johannes Rainer
}
