% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readCosmxSXE.R
\name{readCosmxSXE}
\alias{readCosmxSXE}
\title{Load data from a Nanostring CosMx experiment}
\usage{
readCosmxSXE(
  dirName = dirName,
  returnType = "SPE",
  countMatPattern = "exprMat_file.csv",
  metaDataPattern = "metadata_file.csv",
  coordNames = c("CenterX_global_px", "CenterY_global_px"),
  addFovPos = TRUE,
  fovPosPattern = "fov_positions_file.csv",
  altExps = c("NegPrb", "Negative", "SystemControl", "FalseCode"),
  addParquetPaths = TRUE,
  ...
)
}
\arguments{
\item{dirName}{a directory path to CosMx download that contains files of interest.}

\item{returnType}{option of \code{"SPE"} or \code{"SCE"}, stands for
\code{SpatialExperiment} or \code{SingleCellExperiment} object. Default value \code{"SPE"}}

\item{countMatPattern}{a filename pattern for the count matrix. Default value is
\code{"exprMat_file.csv"}, and there is no need to change.}

\item{metaDataPattern}{a filename pattern for the metadata .csv file that
contains spatial coords. Default value is \code{"metadata_file.csv"}, and
there is no need to change.}

\item{coordNames}{a vector of two strings specify the spatial coord names.
Default value is \code{c("CenterX_global_px", "CenterY_global_px")}, and
there is no need to change.}

\item{addFovPos}{to read in fov_position_list.csv and add the data frame to
\code{metadata(sxe)$fov_positions} or not. Default is TRUE.}

\item{fovPosPattern}{.csv pattern of fov_position_list.csv files in the raw download.
Default value is \code{"fov_positions_file.csv"}.}

\item{altExps}{gene names contains these strings will be moved to \code{altExps(sxe)}
as separate sxe-s. Default is \code{c("NegPrb", "Negative", "SystemControl", "FalseCode")}.}

\item{addParquetPaths}{to add parquet paths to \code{metadata(sxe)} or not. If TRUE,
transcripts and polygon .csv files will be converted to .parquet, and the paths
will be added. If, for instance, no polygon file is available, and only transcript
file is available, please set this argument to TRUE and adjust \code{addPolygon = FALSE}
in the \code{...} argument. Default is TRUE.}

\item{...}{extra parameters to pass to \code{\link{addParquetPathsCosmx}()}, including
\code{addTx}, \code{txMetaNames}, \code{txPattern}, \code{addPolygon}, \code{polygonMetaNames},
\code{polygonPattern}.}
}
\value{
a \code{\link{SpatialExperiment}} or a \code{\link{SingleCellExperiment}} object
}
\description{
Creates a \code{\link{SpatialExperiment}} from the downloaded unzipped CosMx
directory for Nanostring CosMx spatial gene expression data.
}
\details{
The constructor assumes the downloaded unzipped CosMx folder has the following
structure, with two mandatory files:
CosMx_unzipped/optional_default_folder/ \cr
· | — *_exprMat_file.csv \cr
· | — *_metadata_file.csv \cr

Optional files to add to the metadata() as a list of paths (will be converted to parquet):
· | — *_fov_positions_file.csv \cr
· | — *_tx_file.csv \cr
· | — *_polygons.csv \cr
If no optional files, need to set \code{addFovPos = FALSE} and \code{addParquetPaths = FALSE}.
If only one of \verb{*_tx_file.csv} or \verb{*_polygons.csv} exists, set \code{addParquetPaths = TRUE} but
set the not available \code{addTx} or \code{addPolygon} to \code{FALSE}.
See \code{\link{addParquetPathsCosmx}()}
}
\examples{
# A relatively small data download can be from:
# https://nanostring.com/resources/smi-ffpe-dataset-lung9-rep1-data/


# A mock counts and mock metadata with spatial location generated for a 8 genes by 
# 9 cells object is in /extdata: 

cospath <- system.file(
  file.path("extdata", "CosMx_small"),
  package = "SpatialExperimentIO")
  
list.files(cospath)

# One of the following depending on your output (`SPE` or `SCE`) requirement.
cos_spe <- readCosmxSXE(dirName = cospath, addPolygon = FALSE)
cos_sce <- readCosmxSXE(dirName = cospath, returnType = "SCE", addPolygon = FALSE)
cos_spe <- readCosmxSXE(dirName = cospath, addParquetPaths = FALSE)


}
\author{
Yixing Estella Dong
}
