% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reverseDecon.R
\name{reverseDecon}
\alias{reverseDecon}
\title{Reverse deconvolution}
\usage{
reverseDecon(norm, beta, epsilon = NULL)
}
\arguments{
\item{norm}{Matrix of normalized data, with genes in rows and observations in columns}

\item{beta}{Matrix of cell abundance estimates, with cells in rows and observations in columns.
Columns are aligned to "norm".}

\item{epsilon}{All y and yhat values are thresholded up to this point when performing decon.
Essentially says, "ignore variability in counts below this threshold."}
}
\value{
A list:
\itemize{
\item coefs, a matrix of coefficients for genes * cells, where element i,j is interpreted as
"every unit increase in cell score j is expected to increase expression of gene i by _".
\item yhat, a matrix of fitted values, in the same dimension as norm
\item resids, a matrix of log2-scale residuals from the reverse decon fit, in the same
 dimension as norm
\item cors, a vector giving each gene's correlation between fitted and observed expression
\item resid.sd, a vector of each gene's residual SD, a metric of how much variability genes
 have independend of cell mixing.
}
}
\description{
Performs "reverse deconvolution", modelling each gene expression's ~ cell scores.
Returns a matrix of "fitted" expression values, a matrix of residuals, a matrix of
reverse decon coefficients for genes * cells.
}
\examples{
data(mini_geomx_dataset)
data(safeTME)
# estimate background:
mini_geomx_dataset$bg <- derive_GeoMx_background(
  norm = mini_geomx_dataset$normalized,
  probepool = rep(1, nrow(mini_geomx_dataset$normalized)),
  negnames = "NegProbe"
)
# run basic decon:
res0 <- spatialdecon(
  norm = mini_geomx_dataset$normalized,
  bg = mini_geomx_dataset$bg,
  X = safeTME
)
# run reverse decon:
rdecon <- reverseDecon(
  norm = mini_geomx_dataset$norm,
  beta = res0$beta
)
}
