% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hdutils.R
\name{calculate_overlap_directed}
\alias{calculate_overlap_directed}
\title{calculate_overlap_directed}
\usage{
calculate_overlap_directed(
  pat_hotspots,
  influence_hotspots,
  patternList = NULL,
  method = c("relative-abundance", "differential-abundance", "absolute")
)
}
\arguments{
\item{pat_hotspots}{A data frame with columns x, y, barcode and pattern names}

\item{influence_hotspots}{A data frame with columns x, y, barcode and pattern names}

\item{patternList}{A character vector of pattern names to calculate overlap
scores for. If NULL, all patterns in pat_hotspots and influence_hotspots will be used.}

\item{method}{The method to calculate overlapping abundance scores. Options are
"relative-abundance", "differential-abundance" and "absolute"}
}
\value{
A data frame with columns pattern, influence and overlapping abundance
}
\description{
Calculate the overlap scores between patterns in hotspots
}
\details{
The function calculates the overlap scores between patterns hotspots
using the specified method. The default method is "relative-abundance"
}
\examples{
hotspots <- data.frame(x = c(1,2,3,4,5),
                        y = c(1,2,3,4,5),
                        barcode = c("A","B","C","D","E"),
                        pattern1 = c(1,0,1,0,1),
                        pattern2 = c(1,1,0,0,1))
influence_hotspots <- data.frame(x = c(1,2,3,4,5),
                       y = c(1,2,3,4,5),
                      barcode = c("A","B","C","D","E"),
                      pattern1 = c(0,1,1,0,0),
                      pattern2 = c(0,1,0,1,1))
calculate_overlap_directed(pat_hotspots = hotspots, influence_hotspots = influence_hotspots)
}
