% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normalization_correction.R
\name{getRatioMatrix}
\alias{getRatioMatrix}
\title{Get Ratio Matrix of Phosphoproteome Data}
\usage{
getRatioMatrix(maeData, normalization = FALSE, getAdjustedPP = FALSE)
}
\arguments{
\item{maeData}{A \code{MultiAssayExperiment} object containing
phosphoproteome and full proteome data.}

\item{normalization}{A \code{logical} value indicating whether to perform
normalization. Default is \code{FALSE}.}

\item{getAdjustedPP}{A \code{logical} value indicating whether to use
adjusted phosphoproteome data. Default is \code{FALSE}.}
}
\value{
A numeric \code{matrix} representing the ratio of intensity of PP
(phosphoproteome) data to FP (full proteome) data.
}
\description{
\code{getRatioMatrix} calculates the ratio matrix of phosphoproteome data
from a \code{MultiAssayExperiment} object.
}
\examples{
# Load multiAssayExperiment object
data("dia_example")
# Call the function
getRatioMatrix(dia_example, normalization = TRUE)

}
