% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genewiseAssociations.R
\name{addColumn2geneWiseAssociation}
\alias{addColumn2geneWiseAssociation}
\title{Add column to gene-wise association}
\usage{
addColumn2geneWiseAssociation(
  type = "",
  name = NULL,
  coordinates = NULL,
  columnName = NA,
  column,
  inFile = "geneWiseAssociation",
  outFile = "geneWiseAssociation"
)
}
\arguments{
\item{type}{type of columns to be added. Either "gene" or "peak"}

\item{name}{Names of genes or peaks}

\item{coordinates}{Coordinates of genes or peaks in granges format}

\item{columnName}{Column name that should be added to the tables}

\item{column}{Column values that should be added to the tables}

\item{inFile}{The name of the input folder (default "genewiseAssociation")}

\item{outFile}{The name of the output folder (default "genewiseAssociation")}
}
\value{
No value returns just column would be added to the tables
}
\description{
Add a column of values based on the type either genes or peaks.

The Input is either coordinates or names of genes or peaks plus

a column of relevant values. This function add these values as

a column to gene or peak table as well as the interaction table.
}
\examples{
geneFile=system.file("extdata", "gene_expression.tsv", package="Site2Target")
geneCoords <- Table2Granges(geneFile)
geneTable <- read.table(geneFile, header=TRUE)

geneDEIndices <- which((abs(geneTable$logFC)>1)==TRUE)
indicesLen <- length(geneDEIndices)
if(indicesLen >0)
{
    geneTable <- geneTable[geneDEIndices,]
    geneCoords <- geneCoords[geneDEIndices]
}
geneDENames <- geneTable$name
geneDElogFC <- geneTable$logFC
geneCoordsDE <- geneCoords

tfFile =system.file("extdata", "MEIS_binding.tsv", package="Site2Target")
TFCoords <- Table2Granges(tfFile)
tfTable <- read.table(tfFile, header=TRUE)
tfIntensities <- tfTable$intensities

stats <-
genewiseAssociation(associationBy="distance",
                    geneCoordinates=geneCoordsDE,
                    geneNames=geneDENames,
                    peakCoordinates=TFCoords,
                    distance=50000,
                    outFile="Gene_TF_50K")
stats

# add expression log fold changes to the table
addColumn2geneWiseAssociation(type="gene", name=geneDENames,
   columnName="Expr_logFC", column=geneDElogFC, inFile="Gene_TF_50K",
   outFile="Gene_TF_50K")

# add peak intensitites to the table
addColumn2geneWiseAssociation(type="peak", coordinates=TFCoords,
   columnName="Binding_Intensities", column=tfIntensities,
   inFile="Gene_TF_50K", outFile="Gene_TF_50K")
}
\seealso{
\code{\link{genewiseAssociation}}
}
