% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SCSRNet-class.R, R/SCSRNoNet-class.R
\name{getParacrines}
\alias{getParacrines}
\alias{getParacrines,SCSRNet-method}
\alias{getParacrines,SCSRNoNet-method}
\title{Method to retrieve paracrine interactions}
\usage{
\S4method{getParacrines}{SCSRNet}(obj, source.pop, target.pop)

\S4method{getParacrines}{SCSRNoNet}(obj, source.pop, target.pop)
}
\arguments{
\item{obj}{A SCSRNoNet object.}

\item{source.pop}{Name of the cell population from which
ligand-receptor interactions originate (express the ligands).}

\item{target.pop}{Name of the cell population towards which
ligand-receptor interactions go (express the receptors).}
}
\value{
A BSRInferenceComp object.

A data.frame.
}
\description{
Method to retrieve paracrine interactions

Method to retrieve paracrine interactions
}
\details{
A  \code{\link[BulkSignalR]{BSRInferenceComp-class}} object is returned that
contains all the inferred (unfiltered) interactions.

Interactions in tabular format can be obtained applying the
\code{\link[BulkSignalR]{LRinter}} accessor to the returned object. All
the BSRInferenceComp methods to reduce pathway, ligand, or receptor
redundancies can also be applied to the return object.

A data.frame is returned that
contains the inferred interactions.
}
\examples{
print("getParacrines")
data(example_dataset, package = "SingleCellSignalR")
mat <- log1p(data.matrix(example_dataset[, -1])) / log(2)
rownames(mat) <- example_dataset[[1]]
rme <- rowMeans(mat)
mmat <- mat[rme > 0.05, ]
d <- dist(t(mmat))
h <- hclust(d, method = "ward.D")
pop <- paste0("pop_", cutree(h, 5))
scsrcn <- SCSRNet(mat,
normalize = FALSE, method = "log-only",
log.transformed = TRUE, populations = pop
)
if(FALSE){
# infer ligand-receptor interactions from the comparison

scsrcn <- performInferences(scsrcn,
verbose = TRUE, min.logFC = 1e-10,
max.pval = 1)

getParacrines(scsrcn, "pop_1","pop_2")
}
print("getParacrines")
data(example_dataset, package = "SingleCellSignalR")
mat <- log1p(data.matrix(example_dataset[, -1])) / log(2)
rownames(mat) <- example_dataset[[1]]
rme <- rowMeans(mat)
mmat <- mat[rme > 0.05, ]
d <- dist(t(mmat))
h <- hclust(d, method = "ward.D")
pop <- paste0("pop_", cutree(h, 5))
scsrcn <- SCSRNoNet(mat,
normalize = FALSE, method = "log-only",
log.transformed = TRUE, populations = pop
)
if(FALSE){
# infer ligand-receptor interactions from the comparison

scsrcn <- performInferences(scsrcn,
    verbose = TRUE, ,
    min.logFC = 1e-10, max.pval = 1)

getParacrines(scsrcn, "pop_1","pop_2")
}  
}
