% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scaeSubset.R
\name{scae_subset}
\alias{scae_subset}
\title{Subset SCAE object}
\usage{
scae_subset(
  scae,
  subset = c("nonimmune", "alleles", "immune_genes", "functional_groups")
)
}
\arguments{
\item{scae}{SCAE object}

\item{subset}{Character string specifying a data layer. Valid values are
\code{subset=c("nonimmune", "alleles", "immune_genes", "functional_groups")}.}
}
\value{
SCAE object
}
\description{
Function used for subsetting the different layers stored in a
SingleCellAlleleExperiment object. Valid subset values are:
\code{subset=c("nonimmune", "alleles", "immune_genes", "functional_groups")}.
}
\examples{
example_data_5k <- scaeData::scaeDataGet(dataset="pbmc_5k")
lookup_name <- "pbmc_5k_lookup_table.csv"
lookup <- read.csv(system.file("extdata", lookup_name, package="scaeData"))

scae <- read_allele_counts(example_data_5k$dir,
                          sample_names="example_data_wta",
                          filter_mode="no",
                          lookup_file=lookup,
                          barcode_file=example_data_5k$barcodes,
                          gene_file=example_data_5k$features,
                          matrix_file=example_data_5k$matrix,
                          filter_threshold=0,
                          verbose=TRUE)

scae

scae_nonimmune_subset <- scae_subset(scae, subset="nonimmune")
scae_nonimmune_subset

scae_alleles_subset <- scae_subset(scae, subset="alleles")
scae_alleles_subset

scae_immune_genes_subset <- scae_subset(scae, subset="immune_genes")
scae_immune_genes_subset

scae_functional_groups_subset <- scae_subset(scae, subset="functional_groups")
scae_functional_groups_subset

}
