% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/census.R
\name{census}
\alias{census}
\title{Applies the Census count transformation on a count matrix}
\usage{
census(
  matrix,
  exp_capture_rate = 0.25,
  expr_threshold = 0,
  BPPARAM = BiocParallel::bpparam(),
  run_parallel = FALSE
)
}
\arguments{
\item{matrix}{sparse count matrix; cells in columns, genes in rows}

\item{exp_capture_rate}{expected capture rate; default=0.25}

\item{expr_threshold}{expression threshold; default=0}

\item{BPPARAM}{BiocParallel::bpparam() by default; if specific number of threads x want to be used, insert: BiocParallel::MulticoreParam(workers = x)}

\item{run_parallel}{boolean, decide if multi-threaded calculation will be run. FALSE by default}
}
\value{
a vector for each cell-type, with a scaling factor which can be used to transform the counts of the matrix
}
\description{
needs a sparse matrix with cells in columns and genes in rows. You can find the detailed explaination here:
\url{http://cole-trapnell-lab.github.io/monocle-release/docs/#census}
}
\examples{

tpm <- Matrix::Matrix(matrix(rpois(3e5, 5), ncol = 300), sparse = TRUE)
tpm <- Matrix::t(1e6 * Matrix::t(tpm) / Matrix::colSums(tpm))
cen <- SimBu::census(tpm)

}
