% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulator.R
\docType{package}
\name{SimBu}
\alias{SimBu}
\title{SimBu: Bias-aware simulation of bulk RNA-seq data with variable cell type composition}
\description{
As complex tissues are typically composed of various cell types, deconvolution tools have been developed to computationally
infer their cellular composition from bulk RNA sequencing (RNA-seq) data. To comprehensively assess deconvolution performance,
gold-standard datasets are indispensable. The simulation of ‘pseudo-bulk’ data, generated by aggregating single-cell RNA-seq (scRNA-seq)
expression profiles in pre-defined proportions, offers a scalable and cost-effective way of generating these gold-standard datasets.
SimBu was developed to simulate pseudo-bulk samples based on various simulation scenarios, designed to test specific features of deconvolution
methods. A unique feature of SimBu is the modelling of cell-type-specific mRNA bias using experimentally-derived or data-driven scaling factors.
}
\section{Dataset generation}{

You will need an annotated scRNA-seq dataset (as matrix file, h5ad file, Seurat object), which is the baseline for the simulations.
Use the dataset_* functions to generate a SummarizedExperiment, that holds all important information.
It is also possible to access scRNA-seq datasets through the public database Sfaira, by using the functions dataset_sfaira() and
dataset_sfaira_multiple().
}

\section{Simulation}{

Use the simulate_bulk() function to generate multiple pseudo-bulk samples, which will be returned as a SummarizedExperiment. You can
adapt the cell type fractions in each sample by changing the scenario parameter.
}

\section{Visulaization}{

Inspect the cell type composition of your simulations with the plot_simulation() function.
}

