\name{DENBStatPermut4GSEA}
\alias{DENBStatPermut4GSEA}
\title{
Calculate NB-statistics quantifying DE for each gene in the permutation data sets
}
\description{
Calculate NB-statistics quantifying differential expression for each gene in the permutation data sets. The results will be used for GSEA run. 
}
\usage{
DENBStatPermut4GSEA(dds, permuteMat)
}
\arguments{
  \item{dds}{a DESeqDataSet object, can be the output of \code{\link{runDESeq}}.}
  \item{permuteMat}{a permutation matrix generated by \code{\link{genpermuteMat}}. }
}
\note{
The results with the output of \code{\link{DENBStat4GSEA}} can also be used to run \code{\link{DEpermutePval}}. 
}
\value{
A matrix of NB-statistics. Each row corresponds to each gene, and each column to each permutation. 
}
\references{
Xi Wang and Murray J. Cairns (2013). Gene Set Enrichment Analysis of RNA-Seq Data: Integrating Differential Expression and Splicing. BMC Bioinformatics, 14(Suppl 5):S16.
}
\author{
Xi Wang, xi.wang@newcastle.edu.au
}
\seealso{
\code{\link{DENBStat4GSEA}},
\code{\link{runDESeq}},
\code{\link{DEpermutePval}},
\code{\link{genpermuteMat}}
}
\examples{
data(RCS_example, package="SeqGSEA")
permuteMat <- genpermuteMat(RCS_example, times=10)
geneCounts <- getGeneCount(RCS_example)
label <- label(RCS_example)
dds <- runDESeq(geneCounts, label)
DEpermNBstat <- DENBStatPermut4GSEA(dds, permuteMat) 
DEpermNBstat[1:10,1:10]
}
