% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert4mapDIA.R
\name{convert4mapDIA}
\alias{convert4mapDIA}
\title{Convert table into the format for mapDIA}
\usage{
convert4mapDIA(data, RT = FALSE)
}
\arguments{
\item{data}{A data frame containing SWATH data.}

\item{RT}{Option to export the retention times.}
}
\value{
Returns a data frame in the appropriate format for mapDIA.
}
\description{
This functions selects the columns necessary for mapDIA.
}
\note{
The table must not contain any technical replica, the intensity of
  technical replica is averaged. This function requires the package
  reshape2.
}
\examples{
{
 data("OpenSWATH_data", package="SWATH2stats")
 data("Study_design", package="SWATH2stats")
 data <- sample_annotation(OpenSWATH_data, Study_design)
 data.filtered.decoy <- filter_mscore(data, 0.01)
 raw <- disaggregate(data.filtered.decoy)
 data.mapDIA <- convert4mapDIA(raw, RT=TRUE)
 }
}
\references{
Teo, G., et al. (2015). "mapDIA: Preprocessing and statistical
  analysis of quantitative proteomics data from data independent acquisition
  mass spectrometry." J Proteomics 129: 108-120.
}
\author{
Peter Blattmann
}
