% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/STATegRa_holistOmics.R
\name{holistOmics}
\alias{holistOmics}
\alias{holistOmics,list,character-method}
\title{HolistOmics an application of NPC on omics datasets}
\usage{
holistOmics(dataInput, dataTypes, comb.method = c("Fisher", "Liptak", "Tippett"),
               numPerm = 1000, numCores = 1, verbose = FALSE)
}
\arguments{
\item{dataInput}{List of ExpressionSet objects, one for each data modality.}

\item{dataTypes}{Character vector with possible values: 'RNA-seq', 'microarray'}

\item{comb.method}{Character vector with possible values: 'Fisher', 'Liptak',
'Tippett', if more than one is specified, all will be used.}

\item{numPerm}{Number of permutations}

\item{numCores}{Number of CPU cores to use}

\item{verbose}{Logical, if set to TRUE holistOmics prints out the step that it performs}
}
\value{
A data.frame
}
\description{
This function is defunct. Use omicsNPC instead.
}
\examples{
# Load the data
data("TCGA_BRCA_Batch_93")
# Setting dataTypes, the first two ExpressionSets include RNAseq data,
# the third ExpressionSet includes Microarray data.
dataTypes <- c("RNAseq", "RNAseq", "Microarray")
# Setting methods to combine pvalues
comb.method = c("Fisher", "Liptak", "Tippett")
# Setting number of permutations
numPerm = 1000
# Setting number of cores
numCores = 1
# Setting holistOmics to print out the steps that it performs.
verbose = TRUE
# Run holistOmics analysis.
# The output is a data.frame of p-values.
# Each row corresponds to a gene name. Each column corresponds to a method
# used in the analysis.
\dontrun{out <- holistOmics(dataInput = TCGA_BRCA_Data, dataTypes = dataTypes,
                            comb.method = comb.method, numPerm = numPerm,
                            numCores = numCores, verbose = verbose)}
}
\references{
Pesarin, Fortunato, and Luigi Salmaso. Permutation tests for complex data: theory, applications and software.
John Wiley & Sons, 2010.
}
\author{
Nestoras Karathanasis
}
