% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/STATegRa_omicsPCA_caClass.R
\name{getInitialData}
\alias{getInitialData}
\alias{getInitialData,caClass-method}
\title{Retrieve initial data from caClass objects}
\usage{
getInitialData(x, block=NULL)
}
\arguments{
\item{x}{\code{\link{caClass-class}} object.}

\item{block}{Character indicating the block of data to be returned. It can be specified by the position of the block ("1" or "2") or the name assigned in the \code{\link{caClass-class}} object. If it is NULL both blocks are displayed.}
}
\value{
The requested data block or blocks
}
\description{
Generic function to retrieve the initial data used for by \code{\link{omicsCompAnalysis}} from a \code{\link{caClass-class}} object
}
\examples{
data("STATegRa_S3")
B1 <- createOmicsExpressionSet(Data=Block1.PCA, pData=ed.PCA,
                               pDataDescr=c("classname"))
B2 <- createOmicsExpressionSet(Data=Block2.PCA,
                               pData=ed.PCA, pDataDescr=c("classname"))
# Omics components analysis
res <- omicsCompAnalysis(Input=list(B1, B2), Names=c("expr", "mirna"),
                         method="DISCOSCA", Rcommon=2, Rspecific=c(2, 2),
                         center=TRUE, scale=TRUE, weight=TRUE)
getInitialData(res)
getInitialData(res, block="expr")
}
\seealso{
\code{\link{omicsCompAnalysis}}, \code{\link{caClass-class}}
}
\author{
Patricia Sebastian-Leon
}
