% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annotate_re_genes.R
\name{.standardize_peaks}
\alias{.standardize_peaks}
\title{Standardizes peak input, ensuring that input peaks is a \code{GRanges} object,
removes alternate scaffolds (\code{_alt}, \code{random}, \code{fix}, \code{Un}),
and assigns region IDs as names.}
\usage{
.standardize_peaks(peaks)
}
\arguments{
\item{peaks}{A \code{data.frame} with genomic coordinates and a \code{region_id}
column, or a \code{GRanges} object with a \code{region_id} column.}
}
\value{
A \code{GRanges} object with:
\describe{
\item{seqnames, start, end}{Coordinates of the input regions.}
\item{region_id}{Unique identifier of the region (e.g., \code{chr1-5000-5800}).}
\item{metadata columns}{Any additional columns present in the input.}
}
}
\description{
Standardizes peak input, ensuring that input peaks is a \code{GRanges} object,
removes alternate scaffolds (\code{_alt}, \code{random}, \code{fix}, \code{Un}),
and assigns region IDs as names.
}
