% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annotate_re_genes.R
\name{annotate_with_coaccessibility}
\alias{annotate_with_coaccessibility}
\title{Annotate peaks with co-accessible genes using Cicero links}
\usage{
annotate_with_coaccessibility(
  peaks,
  txdb,
  links_df,
  annot_dbi,
  protein_coding_only = TRUE,
  verbose = TRUE,
  add_tss_annotation = FALSE,
  upstream,
  downstream
)
}
\arguments{
\item{peaks}{A \code{GRanges} or \code{data.frame} of peaks with at least the following columns:
\describe{
\item{seqnames}{Chromosome name of the regulatory region (e.g., \code{"chr1"}). Only for data.frames.}
\item{start}{Start coordinate of the peak. Only for data.frames.}
\item{end}{End coordinate of the peak. Only for data.frames.}
\item{region_id}{Unique identifier of the region (e.g., \code{chr1-5000-5800})}
}}

\item{txdb}{\code{TxDb} object for genome annotation (required if annotation requested).}

\item{links_df}{A \code{data.frame} with Cicero links. Must contain columns:
\code{Peak1}, \code{Peak2}, and \code{coaccess}.}

\item{annot_dbi}{\code{AnnotationDbi} object for gene ID mapping (required if annotation requested).}

\item{protein_coding_only}{Logical; restrict to protein-coding genes (default TRUE).}

\item{verbose}{Logical; print messages (default TRUE).}

\item{add_tss_annotation}{Logical; annotate regulatory elements overlapping TSS (default FALSE).
If TRUE, use +/- 1bp TSS.}

\item{upstream}{Single integer value indicating the number of bases upstream
from the TSS (transcription start sites) (default \code{"2000kb"}).}

\item{downstream}{Single integer values indicating the number of bases downstream
from the TSS (transcription start sites) (default \code{"2000kb"}).}
}
\value{
A \code{data.frame} with the original metadata columns from \code{peaks},
along with an added \code{gene_id} column containing the symbol of the co-accessible gene.
Peaks with no gene annotation will have \code{NA} in the \code{gene_id} field.
}
\description{
Links peaks to genes based on Cicero co-accessibility with promoters or TSSs.
}
\examples{
library(TxDb.Hsapiens.UCSC.hg38.knownGene)
library(org.Hs.eg.db)

data(atac)
data(cicero_links)

peaks <- unique(unlist(atac)[, c("region_id")])
annotation_coacc <- annotate_with_coaccessibility(
  peaks = peaks,
  txdb = TxDb.Hsapiens.UCSC.hg38.knownGene,
  links_df = cicero_links,
  annot_dbi = org.Hs.eg.db,
  protein_coding_only = TRUE,
  verbose = TRUE,
  add_tss_annotation = FALSE,
  upstream = 2000,
  downstream = 2000
)
}
