% Generated by roxygen2: do not edit by hand
% Please edit documentation in
%   R/calculate_summary_distances_of_cells_to_borders.R
\name{calculate_summary_distances_of_cells_to_borders}
\alias{calculate_summary_distances_of_cells_to_borders}
\title{calculate_summary_distances_of_cells_to_borders}
\usage{
calculate_summary_distances_of_cells_to_borders(
  spe_object,
  cell_types_of_interest,
  feature_colname = "Cell.Type"
)
}
\arguments{
\item{spe_object}{SpatialExperiment object. It should contain information of
tissue structure and cell distances to the tissue region border (`colData()` has
`Region` and `Distance.To.Border` columns).}

\item{cell_types_of_interest}{String Vector of cell types to consider.}

\item{feature_colname}{String specifying which column the interested cell
types are from.}
}
\value{
A data.frame is returned
}
\description{
Returns the mean, median and standard deviation of the distances
  between a specified cell type to the border.
}
\examples{
spe_border <- identify_bordering_cells(SPIAT::defined_image,
reference_cell = "Tumour", feature_colname = "Cell.Type", n_to_exclude = 10)
spe_dist <- calculate_distance_to_margin(spe_border)
spe_structure <- define_structure(spe_dist, cell_types_of_interest =
c("Immune1","Immune2","Immune3"), feature_colname = "Cell.Type",
n_margin_layers = 5)
calculate_summary_distances_of_cells_to_borders(spe_structure,
cell_types_of_interest = c("Immune1","Immune3"),feature_colname = "Cell.Type")
}
