% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_cell_distances_violin.R
\name{plot_cell_distances_violin}
\alias{plot_cell_distances_violin}
\title{plot_cell_distances_violin}
\usage{
plot_cell_distances_violin(cell_to_cell_dist)
}
\arguments{
\item{cell_to_cell_dist}{Data.frame containing the distance output between cell types. The
functions that generate the distances can be
\code{\link{calculate_minimum_distances_between_celltypes}} and
\code{\link{calculate_pairwise_distances_between_celltypes}}.}
}
\value{
A plot is returned
}
\description{
Plots distances between cells as a violin plot
}
\examples{
distances <- calculate_pairwise_distances_between_celltypes(SPIAT::defined_image,
cell_types_of_interest = c("Immune1", "Immune2"), feature_colname="Cell.Type")
plot_cell_distances_violin(distances)
}
