% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/format_colData_to_spe.R
\name{format_colData_to_spe}
\alias{format_colData_to_spe}
\title{format_colData_to_spe}
\usage{
format_colData_to_spe(df)
}
\arguments{
\item{df}{Data frame that contains cell coordinates, phenotypes (if
available) and other cell properties. The rownames should be cell ID}
}
\value{
An SpatialExperiment object
}
\description{
Format a data frame into a SpatialExperiment class where the
  count assay is empty every cell (columns), cell phenotypes are stored under
  colData() and cell coordinates are stored under spatialCoords().
}
\examples{
df <- data.frame(row.names = c("Cell_1", "Cell_2"), Cell.X.Position = c(2,5),
Cell.Y.Position = c(3.3, 8), Phenotypes = c("CD3", "CD3,CD8"))
spe <- format_colData_to_spe(df)
}
